package com.hero.objects.modifiers;

import java.util.ArrayList;

import org.jdom.Element;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Power;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class AlternateCombatValue extends Modifier {

	private static String xmlID = "ACV";

	public AlternateCombatValue(Element root) {
		super(root, AlternateCombatValue.xmlID);
	}

	@Override
	public ArrayList<Adder> getOptions() {
		ArrayList<Adder> sup = super.getOptions();
		ArrayList<Adder> ret = new ArrayList<Adder>();
		if ((getProgenitor() == null) || !(getProgenitor() instanceof Power)) {
			return sup;
		}
		GenericObject p = getProgenitor();
		if (p.getTypes().contains("MENTAL")) {
			if (getSelectedOption() != null
					&& getSelectedOption().getXMLID().indexOf("NONMENTAL") >= 0) {
				setSelectedOption(null);
			}
			for (Adder ad : sup) {
				if (ad.getXMLID().indexOf("NONMENTAL") < 0) {
					ret.add(ad);
				}
			}
		} else {
			if (getSelectedOption() != null
					&& getSelectedOption().getXMLID().indexOf("NONMENTAL") < 0) {
				setSelectedOption(null);
			}
			for (Adder ad : sup) {
				if (ad.getXMLID().indexOf("NONMENTAL") >= 0) {
					ret.add(ad);
				}
			}
		}
		return ret;
	}

	@Override
	public Adder getSelectedOption() {
		Adder ret = super.getSelectedOption();
		if ((getProgenitor() == null) || !(getProgenitor() instanceof Power)) {
			return ret;
		}
		GenericObject p = getProgenitor();
		if (p.getTypes().contains("MENTAL")) {
			if (ret != null
					&& ret.getXMLID().indexOf("NONMENTAL") >= 0) {
				setSelectedOption(null);
				ret = null;
			}
		} else {
			if (ret != null
					&& ret.getXMLID().indexOf("NONMENTAL") < 0) {
				setSelectedOption(null);
				ret = null;
			}
		}
		return ret;
	}

	@Override
	public String included(GenericObject o) {
		String ret = super.included(o);
		if (ret.trim().length() > 0) {
			return ret;
		}

        if (forceAllow()) return ret;
		if (o.getTarget().equals("OCV") || o.getTarget().equals("ECV")
				|| o.getTarget().equals("OMCV") || o.getTarget().equals("MCV")
				|| o.getTarget().equals("DCV") || o.getTarget().equals("DMCV")
				|| o.getTarget().equals("HEX")) {
			return "";
		} else {
			return getDisplay()+" can only be applied to abilities that are targeted on others.";
		}
	}
}